function g = F(x)
% gradient of potential F(x)
%   F(x) = 1/2*|x|^2 + cos(x1-x2)
% Input:
%   x [2] position
% Output:
%   g [2] gradient 
x1 = x(1); x2 = x(2);
g = [x1-sin(x1-x2) x2+sin(x1-x2)]';
end