function [x,v] = U(x,v,beta,h)
% U step in the splitting
% Input:
%   x [2] position
%   v [2] velocity
%   beta [1] inverse temperature
%   h [1] step size
% Output:
%   x [2] position
%   v [2] velocity

% generate Z1, Z2 Gaussian variables
Z = [h, 1-exp(-h); 1-exp(-h), (1-exp(-2*h))/2];
Z = chol(Z, 'lower'); % Cholesky decomposition
Z = Z * randn(2,2); Z1 = Z(1,:)'; Z2 = Z(2,:)';
% compute x, v
x_ = x + (1-exp(-h)) * v + sqrt(2/beta) * (Z1-Z2);
v_ = exp(-h) * v + sqrt(2/beta) * Z2;
% calculate
x = x_;
v = v_;
end