function a_ref = A_ref(beta)
% compute the ratio of integrals int exp(-F(x1,x2)) * A(x1,x2) / int exp(-F(x1,x2))
% Input:
%   beta [1] inverse temperature
% Output:
%   a_ref [5] corresponding observables

% ---- parameters ---- %
L = 20; % length of interval
N = 6000; % discretization size
x1 = linspace(-L,L,N);
x2 = linspace(-L,L,N);
[X1,X2] = meshgrid(x1,x2);

% ---- compute a_ref ---- %
a_ref = zeros(5,1);
exp_F = exp(-beta*observable.F(X1,X2)); % [N,N]
val_A = A(X1,X2); % {5}*[N,N]
int_F = sum(exp_F,[1 2]); % [1]
for i = 1:5
    int_A = sum(exp_F.*val_A{i},[1,2]);
    a_ref(i) = int_A / int_F;
end
end

% ---- observable function ---- %
function a = A(X1,X2)
a = cell(5,1); % observable on grid
a{1} = exp(-X1.^2/2);
a{2} = exp(-(X1+0.5).^2/2);
a{3} = exp(-(X1+X2).^2/2);
a{4} = exp(-(X1+X2+0.5).^2/2);
a{5} = exp(-abs(X1.*X2)/2);
end