clear
clc

% parameters
T = 2e7; % simulation time
E_list = load("FG.mat").E_list;

% plot the error
set(gcf,'Position',[0 0 450 350])
fontsize(14,"points")
hold on
for id = 1:5
    plot(1:T,log2(E_list(id,:)),'LineWidth',1.2)
end
ylim([-14,0])
box on
grid on
legend("$h=2^{0}$","$h=2^{-1}$","$h=2^{-2}$","$h=2^{-3}$","$h=2^{-4}$","interpreter","latex")
xlabel("simulation time")
ylabel("log_2 of error")
title("Full Gradient Error")