clear
clc

% parameters
beta = 1.8; % inverse temperature
T = 2e7; % simulation time
A_ref = observable.A_ref(beta);
E_list = zeros(5,T);

% simulation with various step sizes h
for id = 1:5

    % paramters
    h = 2^(1-id); % step size
    h_rec = 2^(id-1); % inverse of h
    x = randn(2,1); % initial x
    v = randn(2,1); % initial v
    ITER = round(T/h); % number of iterations
    ITER_0 = ITER/100;
    A_sum = zeros(5,1);
    
    % Langevin simulation
    for iter = 1:ITER
        [x,v] = integrator.UBU(x,v,beta,h);
        A_sum = A_sum + observable.A(x);
        std = sqrt(mean((A_sum / iter - A_ref).^2,1));
        if mod(iter,h_rec) == 0
            E_list(id,iter/h_rec) = std; % record the result
        end
        if mod(iter,ITER_0) == 0
            fprintf("(%d/%d) %g\n", id, iter/ITER_0, std) % print the result 
        end
    end

end
